/*
 * Decompiled with CFR 0.152.
 */
package oracle.sysman.oip.oipc.oipcr;

import java.util.Iterator;
import java.util.List;
import oracle.sysman.oii.oiix.OiixException;
import oracle.sysman.oip.oipc.oipcr.OipcrIResult;
import oracle.sysman.oip.oipc.oipcr.OipcrIResultInfo;

public class OipcrResult
implements OipcrIResult {
    private List m_oResultInfo;
    private int m_iComputedResult;
    private boolean m_bUserVerified;
    public static final OipcrIResult PASSED_RESULT = new OipcrResult(1);
    public static final OipcrIResult FAILED_RESULT = new OipcrResult(7);
    public static final OipcrIResult NOT_EXECUTED_RESULT = new OipcrResult(3);
    private OiixException m_oCause = null;

    public OipcrResult(List oResultInfo) {
        this.m_oResultInfo = oResultInfo;
        this.m_iComputedResult = this.computeResult(oResultInfo);
        this.m_bUserVerified = false;
    }

    private OipcrResult(int iResult) {
        this.m_iComputedResult = iResult;
        this.m_oResultInfo = null;
    }

    public static final OipcrResult getNotExecutedResult(OiixException cause) {
        OipcrResult oRes = new OipcrResult(3);
        oRes.setCause(cause);
        return oRes;
    }

    public int getResult() {
        return this.m_bUserVerified ? 1 : this.m_iComputedResult;
    }

    public int getComputedResult() {
        return this.m_iComputedResult;
    }

    public Iterator getResultDetails() {
        return this.m_oResultInfo != null ? this.m_oResultInfo.iterator() : null;
    }

    private int computeResult(List oResultDetails) {
        int iResult = 3;
        if (oResultDetails != null) {
            int res;
            int iSize = oResultDetails.size();
            iResult = 1;
            for (int i = 0; i < iSize && iResult != 7; iResult |= res, ++i) {
                OipcrIResultInfo oResultInfo = (OipcrIResultInfo)oResultDetails.get(i);
                res = oResultInfo.getResult();
            }
        }
        return iResult;
    }

    public void setUserVerified(boolean bUserVerfied) {
        if (this != NOT_EXECUTED_RESULT || this != PASSED_RESULT || this != FAILED_RESULT) {
            this.m_bUserVerified = bUserVerfied;
        }
    }

    public boolean isUserVerified() {
        return this.m_bUserVerified;
    }

    public OiixException getCause() {
        return this.m_oCause;
    }

    public void setCause(OiixException cause) {
        if (this != NOT_EXECUTED_RESULT && this != PASSED_RESULT && this != FAILED_RESULT) {
            this.m_oCause = cause;
        }
    }

    public int getResultSize() {
        return this.m_oResultInfo == null ? 0 : this.m_oResultInfo.size();
    }
}

